// A small demo of setting a 3d mode in DX8
// original code adapted from Drunken Hyena

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <D3DX8.h>

void FatalError(const char *error_msg);
void FatalError(HRESULT hr,const char *error_msg);
void ask_fullscreen(void);
LRESULT CALLBACK default_window_proc(HWND hwnd,UINT msg,WPARAM wparam,LPARAM lparam);
void init_window(void);
void kill_window(void);
void init_d3d(void);
void kill_d3d(void);
void init_scene(void);
void kill_scene(void);
void message_pump(void);
D3DFORMAT find_16bit_mode(void);
void render(void);
void NOP(HINSTANCE p_prev_instance,LPSTR p_cmd_line,int p_show);

const char g_app_name[]="DirectX 8 Test";
const int g_width=640;
const int g_height=480;

bool g_fullscreen=true;

HWND g_main_window=NULL;

HINSTANCE g_instance;

bool g_app_done=false;

LPDIRECT3D8 g_D3D=NULL;

IDirect3DDevice8 *g_d3d_device=NULL;

int APIENTRY WinMain(HINSTANCE p_instance,HINSTANCE p_prev_instance,LPSTR p_cmd_line,int p_show){

   g_instance=p_instance;
   NOP(p_prev_instance,p_cmd_line,p_show);
   ask_fullscreen();
   init_window();
   init_d3d();
   init_scene();
   while(!g_app_done){
      
      message_pump();
      render();
   }

   kill_scene();
   kill_d3d();
   kill_window();
   return 0;
}

void NOP(HINSTANCE p_prev_instance,LPSTR p_cmd_line,int p_show){

   p_prev_instance=p_prev_instance;
   p_cmd_line=p_cmd_line;
   p_show=p_show;
}

void message_pump(void){
MSG msg;

   if(PeekMessage(&msg, NULL, 0, 0,PM_REMOVE)){
      TranslateMessage(&msg);
      DispatchMessage(&msg);
   }

}

void init_d3d(void){
HRESULT hr;
D3DPRESENT_PARAMETERS d3dpp;
D3DDISPLAYMODE display_mode;

   g_D3D = Direct3DCreate8( D3D_SDK_VERSION );
   if(!g_D3D ){
      FatalError("Error getting Direct3D");
   }

   hr=g_D3D->GetAdapterDisplayMode(D3DADAPTER_DEFAULT,&display_mode);
   if(FAILED(hr)){
      FatalError(hr,"Error getting display mode\n");
   }

   ZeroMemory(&d3dpp,sizeof(d3dpp));

   d3dpp.SwapEffect     = D3DSWAPEFFECT_DISCARD;
   d3dpp.hDeviceWindow  = g_main_window;
   d3dpp.BackBufferCount= 1;

   if(g_fullscreen){
      d3dpp.Windowed          = FALSE;
      d3dpp.BackBufferWidth   = g_width;
      d3dpp.BackBufferHeight  = g_height;
      d3dpp.BackBufferFormat  = find_16bit_mode();
   }else{
      d3dpp.Windowed          = TRUE;
      d3dpp.BackBufferFormat  = display_mode.Format;
   }

   hr=g_D3D->CreateDevice(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL,g_main_window,D3DCREATE_SOFTWARE_VERTEXPROCESSING,&d3dpp,&g_d3d_device);
   if(FAILED(hr)){
      FatalError(hr,"Error creating device\n");
   }
}

void kill_d3d(void){

   if(g_d3d_device){
      g_d3d_device->Release();
      g_d3d_device=NULL;
   }

   if(g_D3D){
      g_D3D->Release();
      g_D3D=NULL;
   }

}
void init_scene(void){
}
void kill_scene(void){
}

D3DFORMAT find_16bit_mode(void){
HRESULT hr;
   hr=g_D3D->CheckDeviceType(D3DADAPTER_DEFAULT,D3DDEVTYPE_HAL,D3DFMT_R5G6B5,D3DFMT_R5G6B5,   //This is the back (drawable) buffer format
                             FALSE);
   if(SUCCEEDED(hr)){
      return D3DFMT_R5G6B5;
   }

   hr=g_D3D->CheckDeviceType(D3DADAPTER_DEFAULT,D3DDEVTYPE_HAL,D3DFMT_X1R5G5B5,D3DFMT_X1R5G5B5,FALSE);
   if(SUCCEEDED(hr)){
      return D3DFMT_X1R5G5B5;
   }
   FatalError("Couldn't find a decent mode\n");
   return (D3DFORMAT)NULL;
}

void ask_fullscreen(void){
int full_result;

   full_result=MessageBox(NULL,"Would you like to run in fullscreen mode?",g_app_name,
                          MB_YESNOCANCEL|MB_ICONQUESTION);
   switch(full_result){
      case IDCANCEL:
         MessageBox(NULL,"User Abort",g_app_name,MB_OK);
         exit(5);
         break;
      case IDNO:
         g_fullscreen=false;
         break;
      case IDYES:
         g_fullscreen=true;
         break;
      case 0:
         OutputDebugString("Couldn't open MessageBox");
         exit(10);
         break;
   }

}

void render(void){
static unsigned char red=0,green=0,blue=0;
red++; green+=2; blue+=3;

   g_d3d_device->Clear(0,NULL,D3DCLEAR_TARGET,D3DCOLOR_XRGB(red,green,blue),1.0f,0 );

      if(SUCCEEDED(g_d3d_device->BeginScene())){

      g_d3d_device->EndScene();
   }

   g_d3d_device->Present(NULL,NULL,NULL,NULL );

}
void init_window(void){
ULONG window_width, window_height;
WNDCLASS window_class;
DWORD style;

   window_class.style          = CS_OWNDC;
   window_class.cbClsExtra     = 0;
   window_class.cbWndExtra     = 0;
   window_class.hInstance      = g_instance;
   window_class.hIcon          = LoadIcon(NULL,IDI_APPLICATION);
   window_class.hCursor        = LoadCursor(NULL,IDC_ARROW);
   window_class.hbrBackground  = (HBRUSH)GetStockObject(BLACK_BRUSH);
   window_class.lpszMenuName   = NULL;
   window_class.lpszClassName  = "DH Class";
   window_class.lpfnWndProc    = default_window_proc;


   //Register the class with windows
   if(!RegisterClass(&window_class)){
      FatalError("Error registering window class");
   }

     if(g_fullscreen){
      window_width=GetSystemMetrics(SM_CXSCREEN);
      window_height=GetSystemMetrics(SM_CYSCREEN);
      style=WS_POPUP;
   }else{
      window_width=g_width;
      window_height=g_height;
      style=WS_OVERLAPPED|WS_SYSMENU;
   }


   g_main_window=CreateWindow("DH Class",g_app_name,style,
                              0,0,window_width,window_height,NULL,NULL,
                              g_instance,NULL);

   if(!g_main_window){
      FatalError("Error opening window");
   }

   ShowWindow(g_main_window,SW_SHOW);
   UpdateWindow(g_main_window);
   SetFocus(g_main_window);

}
void kill_window(void){

   if(g_main_window){
      if(!DestroyWindow(g_main_window)){
         MessageBox(NULL,"Window Failed",g_app_name,MB_OK|MB_ICONERROR|MB_TOPMOST);
      }else{
         MSG msg;
         while(PeekMessage(&msg, NULL, 0, 0,PM_REMOVE)){
            DispatchMessage(&msg);
         }
      }
      g_main_window=NULL;
   }

   if(!UnregisterClass("DH Class",g_instance)){
      MessageBox(NULL,"Unregister Failed",g_app_name,MB_OK|MB_ICONERROR|MB_TOPMOST);
   }

}
void FatalError(const char *error_msg){

   kill_scene();

   kill_d3d();

   kill_window();

	OutputDebugString( error_msg );
   OutputDebugString("\n");
	MessageBox(NULL, error_msg,g_app_name, MB_OK );

   exit(5);

}
void FatalError(HRESULT hr,const char *error_msg){
char buffer[255];

   
   D3DXGetErrorStringA(hr,buffer,250);

   strcat(buffer,"\n");
   strcat(buffer,error_msg);

   kill_scene();
   kill_d3d();
   kill_window();

OutputDebugString( buffer );
OutputDebugString("\n");
MessageBox(NULL, buffer,g_app_name, MB_OK );

   exit(5);

}
LRESULT CALLBACK default_window_proc(HWND hwnd,UINT msg,WPARAM wparam,LPARAM lparam){
   
   switch(msg){
      case WM_KEYDOWN:
         g_app_done=true;
         return 0;
      case WM_CLOSE:
         g_app_done=true;
         return 0;
      case WM_DESTROY:
         PostQuitMessage(0);
         return 0;
   }

   return (DefWindowProc(hwnd,msg,wparam,lparam));

}
